﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using VeteransAffairs.Registries.BusinessManager.EFR;

public partial class controls_DoDFragment : System.Web.UI.UserControl
{
    DoDFragmentManager _manager = new DoDFragmentManager();

    protected void Page_Load(object sender, EventArgs e)
    {
        LoadBaseControls();
    }

    private void Page_PreRender(object sender, EventArgs e)
    {
        LoadControlsFromObject();
    }

    public string LabID
    {
        set
        {
            HiddenFieldLabID.Value = value;
        }
    }

    public string PatientID
    {
        set
        {
            HiddenFieldPatientID.Value = value;
        }
    }

    private void LoadControlsFromObject()
    {
        DOD_FRAGMENT_LAB lab = _manager.GetDoDFragmentLabById(Helpers.getIntFromString(HiddenFieldLabID.Value));

        if (lab != null)
        {
            HiddenFieldPatientID.Value = lab.PATIENT_ID.ToString();
            BaseControlLabelLabName.Text = lab.LAB_NAME;
            BaseControlLabelLabReportDate.Text = lab.LAB_REPORT_DATE;
            BaseControlLabelLabCode.Text = lab.LAB_CODE;
            BaseControlLabelLabID.Text = lab.LAB_ID;
            BaseControlLabelLabAccessionNumber.Text = lab.LAB_ACCESSION_NUMBER;
            BaseControlLabelLabProducingEventDate.Text = lab.PRODUCING_EVENT_DATE;

            PanelDoDFragmentData.GroupingText = "&nbsp;&nbsp;DoD Fragment Data for Lab - "
            + lab.LAB_NAME + "&nbsp;&nbsp;";
        }
    }

    private void LoadBaseControls()
    {
        RegistriesCommonManager commonManager = new RegistriesCommonManager();
        List<STD_GUI_CONTROL> controls = commonManager.GetStdGuiControlsByCategory("DOD_FRAGMENT_CONTROL", EFRSharedConstant.EfrRegistryId);

        foreach (STD_GUI_CONTROL dbItem in controls)
        {
            Control userControl = null;

            userControl = PanelDoDLab.FindControl(dbItem.USER_CONTROL_ID);
            if (userControl != null)
            {
                controls_BaseControlLabel baseControl = (controls_BaseControlLabel)userControl;
                baseControl.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT,
                    dbItem.TOOL_TIP, dbItem.INCLUDE_LABEL);
            }
        }
    }

}
